/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWException;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;

class VWWorkBasketsSelectionTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 3;
    protected static final int COL_NAME = 0;
    protected static final int COL_QUEUE_NAME = 1;
    protected static final int COL_DESCRIPTION = 2;
    protected VWSessionInfo m_sessionInfo = null;
    protected VWRoleDefinition m_roleDef = null;
    protected Vector m_availableItems = null;
    protected Vector m_selectedItems = null;
    protected boolean m_bIsModified = false;

    public VWWorkBasketsSelectionTableModel(VWSessionInfo sessionInfo, VWDataDictionary dataDictionary) {
        try {
            this.m_sessionInfo = sessionInfo;
            this.m_availableItems = new Vector();
            this.m_selectedItems = new Vector();
            this.reinitialize(dataDictionary);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWorkBasketsSelectionTableModel(VWDataDictionary dataDictionary) {
        try {
            this.m_sessionInfo = dataDictionary.getSessionInfo();
            this.m_availableItems = new Vector();
            this.m_selectedItems = null;
            this.reinitialize(dataDictionary);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return JCheckBox.class;
            }
            case 2: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
            case 2: {
                return VWResource.Description;
            }
            case 1: {
                return VWResource.QueueName;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_availableItems.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWWorkBasketDefinition workBasketDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (workBasketDef == null) break;
                    JCheckBox tmpCheckBox = new JCheckBox(workBasketDef.getName());
                    tmpCheckBox.setSelected(this.isSelectedWorkBasket(workBasketDef));
                    return tmpCheckBox;
                }
                case 2: {
                    if (workBasketDef == null) break;
                    return workBasketDef.getDescription();
                }
                case 1: {
                    if (workBasketDef == null) break;
                    return workBasketDef.getQueueName();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
            }
        }
    }

    public VWWorkBasketDefinition[] getSelectedItems() {
        if (this.m_selectedItems.size() > 0) {
            return this.m_selectedItems.toArray(new VWWorkBasketDefinition[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reinitialize(VWDataDictionary dataDictionary) {
        try {
            try {
                VWWorkBasketDefinition[] workBasketDefs;
                this.m_availableItems = new Vector();
                if (dataDictionary != null && (workBasketDefs = dataDictionary.getWorkBasketDefinitions()) != null) {
                    for (int nCounter = 0; nCounter < workBasketDefs.length; ++nCounter) {
                        this.m_availableItems.addElement(workBasketDefs[nCounter]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            throw throwable;
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setRoleDefinition(VWRoleDefinition roleDefinition) {
        try {
            try {
                VWWorkBasketDefinition[] workBasketDefs;
                this.m_roleDef = roleDefinition;
                this.m_selectedItems = new Vector();
                if (this.m_roleDef != null && (workBasketDefs = this.m_roleDef.getWorkBasketDefinitions()) != null) {
                    for (int nIndex = 0; nIndex < workBasketDefs.length; ++nIndex) {
                        this.m_selectedItems.addElement(workBasketDefs[nIndex]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                this.m_bIsModified = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            this.m_bIsModified = false;
            throw throwable;
        }
        this.fireTableDataChanged();
        this.m_bIsModified = false;
    }

    protected void addNewWorkBasket(VWWorkBasketDefinition workBasketDef) throws VWException {
        if (this.m_roleDef == null) {
            return;
        }
        this.m_availableItems.addElement(workBasketDef);
        this.m_selectedItems.addElement(workBasketDef);
        Object[] selectedWorkBasketDefs = null;
        if (this.m_selectedItems.size() > 0) {
            selectedWorkBasketDefs = new VWWorkBasketDefinition[this.m_selectedItems.size()];
            this.m_selectedItems.copyInto(selectedWorkBasketDefs);
        }
        this.m_roleDef.setWorkBasketDefinitions((VWWorkBasketDefinition[])selectedWorkBasketDefs);
        this.m_bIsModified = true;
        int nLastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(nLastRow, nLastRow);
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    protected void releaseResources() {
        if (this.m_availableItems != null) {
            this.m_availableItems.removeAllElements();
            this.m_availableItems = null;
        }
        if (this.m_selectedItems != null) {
            this.m_selectedItems.removeAllElements();
            this.m_selectedItems = null;
        }
        this.m_sessionInfo = null;
        this.m_roleDef = null;
    }

    private VWWorkBasketDefinition getRowItemAt(int nRowIndex) {
        if (this.m_availableItems == null || nRowIndex < 0 || nRowIndex > this.m_availableItems.size()) {
            return null;
        }
        if (nRowIndex < this.m_availableItems.size()) {
            return (VWWorkBasketDefinition)this.m_availableItems.elementAt(nRowIndex);
        }
        return null;
    }

    private boolean isSelectedWorkBasket(VWWorkBasketDefinition workBasketDef) {
        if (this.m_selectedItems == null || this.m_selectedItems.size() == 0) {
            return false;
        }
        return this.m_selectedItems.indexOf(workBasketDef) != -1;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof JCheckBox)) {
                return;
            }
            VWWorkBasketDefinition workBasketDef = this.getRowItemAt(nRowIndex);
            if (workBasketDef != null) {
                if (((JCheckBox)aValue).isSelected()) {
                    this.m_selectedItems.addElement(workBasketDef);
                } else {
                    this.m_selectedItems.removeElement(workBasketDef);
                }
                Object[] selectedWorkBasketDefs = null;
                if (this.m_selectedItems.size() > 0) {
                    selectedWorkBasketDefs = new VWWorkBasketDefinition[this.m_selectedItems.size()];
                    this.m_selectedItems.copyInto(selectedWorkBasketDefs);
                }
                this.m_roleDef.setWorkBasketDefinitions((VWWorkBasketDefinition[])selectedWorkBasketDefs);
                this.m_bIsModified = true;
                this.fireTableCellUpdated(nRowIndex, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }
}

